#include <Struct.h>

DWORD ShowHint( char* pTitle, char* pMessage)
{
  CWnd* pWnd = AfxGetMainWnd();
  if (pWnd)
    return pWnd->MessageBox(pMessage, pTitle, MB_OK|MB_ICONINFORMATION);
  return 0;
}


DWORD CALLBACK SingleOnHelp(tProcParams* params)
{
  return ShowHint("Single selection tool:",
    "   This tool selects or deselect active object, vertex or face. This tool works with\n "
    "right mouse button."
    );
}

DWORD CALLBACK QuadrOnHelp(tProcParams* params)
{
  return ShowHint("Quadr selection tool:",
    "   This tool selects or deselect objects, vertices or faces. Right-click and drag the\n "
    "mouse, holding the right mouse button down. When releasing the right-button, you can\n "
    "press CTRL key to perform deselection, or SHIFT key for extended selection of objects."
    );
}

DWORD CALLBACK CircleOnHelp(tProcParams* params)
{
  return ShowHint("Circle selection tool:",
    "   Works the same way as the Quadr selection tool, but the area of selection is circle."
    );
}

DWORD CALLBACK SeparatedOnHelp(tProcParams* params)
{
  return ShowHint("Separated selection tool:",
    "   This tool selects groups of vertices or faces that are separated from other vertices\n "
    "or faces. Mostly used when the object was cut to subobjects and then fused to one object.\n "
    "Otherwise the whole object selected is the most common result.\n\t Works with right mouse button."
    );
}

DWORD CALLBACK AllOnHelp(tProcParams* params)
{
  return ShowHint("All tool:",
    "   This tool selects all objects, vertices or faces. To deslect all objects you should "
    "use the None tool.\n\t Works with right mouse button."
    );
}

DWORD CALLBACK NoneOnHelp(tProcParams* params)
{
  return ShowHint("None tool:",
    "   This tool deselects all objects, vertices or faces.\n\t Works with right mouse button."
    );
}

DWORD CALLBACK InvertOnHelp(tProcParams* params)
{
  return ShowHint("Invert tool:",
    "   This tool inverts selection.\n\t Works with right mouse button."
    );
}

DWORD CALLBACK ByMaterialOnHelp(tProcParams* params)
{
  return ShowHint("By Material tool:",
    "   This tool selects faces by specified material. To apply this tool\n"
    "switch desired object(s) to faces level and click on the button.\n"
    "   To perform deselection by material, follow the steps:\n"
    "- Invert selection (with Select\\Invert tool)\n"
    "- Perfrom selection by material\n"
    "- Invert selection again.");
}

DWORD CALLBACK UVMappedOnHelp(tProcParams* params)
{
  return ShowHint("UV-Mapped select tool:",
    "   This tool selects faces that has any mapping assigned.\n"
    "It can only be applied on faces level. To perform deselection\n"
    "hold CTRL key when right-clicking on the object.");
}

